# -*- coding: utf-8 -*-
from ladon.ladonizer import ladonize
from mysite.pywebsv.utils import request_valid, datetime2stamp, stamp2datetime, interface_response, online_employee, \
    save_notification, remove_history, user_photo, MESSAGE_CODE, SUCCESS_CODE, SYSTEM_EXCEPTION, DATA_EXCEPTION, \
    paging, push_notification
import json
from django.utils.translation import activate, ugettext_lazy as _


class BioTimeAppLeave(object):

    """
    【Leave】请假
    """

    @request_valid
    @ladonize(int, str, str, str, rtype=str)
    def category(self, source, device_token, language, token):
        """
        获取请假类型
        @param source:          数据来源(1: IOS， 2：Android)
        @param device_token:    消息推送Token
        @param language:
        @param token:
        @rtype:
            请求成功
                {"code":1,"error":"","describe":"","message":"","data":[{"code":对象ID,"name":"类型名称"}]}
            请求失败
                {"code":-10001,"error":"","describe":"","message":"弹窗信息","data":""}
        """
        # from mysite.att.models.model_leaveclass import LeaveClass
        from mysite.att.global_cache import CACHE_LEAVE_CLASS
        try:
            choices = CACHE_LEAVE_CLASS.get()
            # objs = LeaveClass.objects.all().values('LeaveID', 'LeaveName')
            # choices = [{'code': obj['LeaveID'], 'name': obj['LeaveName']} for obj in objs]
            return interface_response(SUCCESS_CODE, json.dumps(choices), '', 'successful')
        except Exception, e:
            import traceback
            traceback.print_exc()
            return interface_response(MESSAGE_CODE, '', '', e, SYSTEM_EXCEPTION)

    @request_valid
    @ladonize(int, long, long, str, int, str, str, str, rtype=str)
    def apply(self, leave_type, start, end, remark, source, device_token, language, token):
        """
        请假申请
        @param leave_type:      请假类型  （数据获取　BioTimeAppLeave --> category ）
        @param start:           请假开始时间
        @param end:             请假结束时间
        @param remark:          备注
        @param source:          数据来源(1: IOS， 2：Android)
        @param device_token:    消息推送Token
        @param language:
        @param token:
        @rtype:
            请求成功
                {"code": 1, "error": "", "describe": "", "message": "", "data":{"message":"弹窗信息"}}
            请求失败
                {"code":-10001,"error":"","describe":"","message":"弹窗信息","data":""}
        """
        from mysite.att.models.model_empspecday import EmpSpecDay
        from mysite.att import constant
        from mysite.att.models.model_leaveclass import LeaveClass
        from mysite.att.att_utils import approve_flow
        import datetime
        from django.db.models import Q
        start = stamp2datetime(start)
        end = stamp2datetime(end)
        if start > end:
            error = 'Wrong Data'
            describe = u'{0}'.format(_(u'结束时间不能小于开始时间'))
            message = u'{0}'.format(_(u'结束时间不能小于开始时间'))
            return interface_response(MESSAGE_CODE, '', error, describe, message)
        applier = online_employee()
        print "[*]Employee:", applier
        tmp = EmpSpecDay.objects.filter(emp=applier, audit_status=constant.AUDIT_SUCCESS).exclude(Q(start__gt=end) | Q(end__lt=start))
        if tmp:
            error = 'Wrong Data'
            describe = u'{0}'.format(_(u'人员 %s 请假时间有重叠') % applier)
            message = u'{0}'.format(_(u'人员 %s 请假时间有重叠') % applier)
            return interface_response(MESSAGE_CODE, '', error, describe, message)
        try:
            lcs = LeaveClass.objects.filter(LeaveID=leave_type)
            leave_type = lcs and lcs[0] or None
            if not leave_type:
                describe = 'Leave type not found'
                return interface_response(MESSAGE_CODE, '', '', describe, DATA_EXCEPTION)
            obj = EmpSpecDay()
            obj.emp = applier
            obj.start = start
            obj.end = end
            obj.leaveclass = leave_type
            obj.reson = u'{0}'.format(remark.decode('utf-8'))
            obj.apply = datetime.datetime.now()
            obj.approve_level = 1
            obj.save()
            obj, approve_level = approve_flow(constant.CATEGORY_LEAVE, obj, applier, applier.PIN, '', None, None)
            obj.save()
            data = {
                'message': u'{0}'.format(_(u'Request already processing'))
            }
            return interface_response(SUCCESS_CODE, json.dumps(data), '', 'successful')
        except Exception, e:
            import traceback
            traceback.print_exc()
            return interface_response(MESSAGE_CODE, '', '', e, u'{0}'.format(e))

    @request_valid
    @ladonize(int, int, str, str, rtype=str)
    def my_application(self, approve_status, page_num, language, token):
        """
        获取自己的调班申请(申请,通过,拒绝)数据
        @param approve_status:  0:通过&拒绝, 1:申请, 2:通过，3：拒绝
        @param page_num:        页码（每页１５条数据）
        @param language:
        @param token:
        @rtype:
            请求成功
                {"code":1,"error":"","describe":"","message":"","data":{"category":1,"items":[{"code":对象ID,"pin":"工号","name":"姓名","photo":"照片地址","start":"请假开始时间","end":"请假结束时间","remark":"申请备注","category":"请假类型(标题)","apply_time":"申请时间","approve_status":"审批状态值(int)","approve_describe":"审批状态","approved_remark":"审批备注","approved_time":"审批时间"}, ]}}
            请求失败
                {"code":-10001,"error":"","describe":"","message":"弹窗信息","data":""}
        """
        from mysite.sql_utils import get_sql, p_query
        from mysite.att import constant
        from mysite.iclock.models.model_notification import CATEGORY_LEAVE

        if approve_status in (0, 1, 2, 3):
            emp = online_employee()
            if not approve_status:
                _approve_status = ' audit_status in (2, 3) '
            else:
                _approve_status = ' audit_status in (%s) ' % approve_status
            where = ' u.userid = %(applier)s and %(audit_status)s  ' % ({'applier': emp.pk, 'audit_status': _approve_status})
            sort_name = 'change_time'
            if approve_status in (1, ): #Apply
                sort_name = 'create_time'
            page_num = page_num or 1
            try:
                sql = get_sql('sql', sqlid='leave_application', app="pywebsv", params={'where': where})
                sql = paging(sql, page_num, sort_name)
                rows = p_query(sql)
                data = {
                    'category': CATEGORY_LEAVE,
                    'items': []
                }
                if rows:
                    status = dict(constant.ALL_STATUS)
                    items = [{'code': r[0], 'pin': r[1], 'name': r[2], 'photo': user_photo(r[1]),
                              'start': datetime2stamp(r[3]), 'end': datetime2stamp(r[4]),
                              'remark': r[5], 'category': r[6], 'apply_time': datetime2stamp(r[7]),
                              'approve_status': r[8], 'approve_describe': u'{0}'.format(status.get(r[8], r[8])),
                              'approved_remark':r[10], 'approved_time': datetime2stamp(r[11])} for r in rows]
                    data['items'] = items
                return interface_response(SUCCESS_CODE, json.dumps(data), '', 'successful')
            except Exception, e:
                import traceback
                traceback.print_exc()
                return interface_response(MESSAGE_CODE, '', '', e, SYSTEM_EXCEPTION)
        else:
            describe = 'parameter approve_status={0} error'.format(approve_status)
            return interface_response(MESSAGE_CODE, '', '', describe, DATA_EXCEPTION)

    @request_valid
    @ladonize(int, int, int, str, str, rtype=str)
    def approval_list(self, approve_status, page_num, order_by, language, token):
        """
        获取审批列表
        @param approve_status:  0:通过&拒绝, 1:申请, 2:通过，3：拒绝
        @param page_num:        页码（每页１５条数据）
        @param order_by:        排序(1: 申请时间，２：审批时间), 申请界面默认为１，审批界面默认为２
        @param language:
        @param token:
        @rtype:
            请求成功
                {"code":1,"error":"","describe":"","message":"","data":[{"code": ID,"pin":"人员工号","name":"名称","photo":"照片地址","start":"请假开始时间(stamp)","end":"请假结束时间(stamp)","remark":"申请备注","category":"类型","apply_time":"申请时间","approve_status":"审核状态值","approve_describe":"审核状态","approved_remark":"审批备注", "approved_time":"审批时间"},]}
            请求失败
                {"code":-10001,"error":"","describe":"","message":"弹窗信息","data":""}
        """
        from mysite.sql_utils import get_sql, p_query
        from mysite.att import constant
        if approve_status in (0, 1, 2, 3):
            emp = online_employee()
            if not approve_status:
                _approve_status = ' audit_status in (%s, %s, %s) ' % (constant.AUDIT_SUCCESS, constant.REFUSE, constant.CANCEL_AUDIT_SUCCESS)
            elif approve_status in (constant.APPLICATION, ):
                _approve_status = ' audit_status in (%s, %s) ' % (constant.APPLICATION, constant.AUDITING)
            elif approve_status in (constant.REFUSE, ):
                _approve_status = ' audit_status in (%s, %s) ' % (constant.REFUSE, constant.CANCEL_AUDIT_SUCCESS)
            else:
                _approve_status = ' audit_status in (%s) ' % approve_status
            where = ' pdr.approver_id = %(approver)s and %(audit_status)s  ' % ({'approver': emp.pk, 'audit_status': _approve_status})
            print "[*]Where:", where
            sort_name = 'change_time'
            if approve_status in (1, ): #Apply
                sort_name = 'create_time'
            page_num = page_num or 1
            try:
                sql = get_sql('sql', sqlid='leave_application', app="pywebsv", params={'where': where})
                sql = paging(sql, page_num, sort_name)
                rows = p_query(sql)
                data = []
                if rows:
                    status = dict(constant.ALL_STATUS)
                    data = [{'code': r[0], 'pin': r[1], 'name': r[2], 'photo': user_photo(r[1]),
                             'start': datetime2stamp(r[3]), 'end': datetime2stamp(r[4]),
                             'remark': r[5], 'category': r[6], 'apply_time': datetime2stamp(r[7]),
                             'approve_status': r[8], 'approve_describe': u'{0}'.format(status.get(r[8], r[8])),
                             'approved_remark':r[10], 'approved_time': datetime2stamp(r[11])
                             } for r in rows]
                return interface_response(SUCCESS_CODE, json.dumps(data), '', 'successful')
            except Exception, e:
                import traceback
                traceback.print_exc()
                return interface_response(MESSAGE_CODE, '', '', e, SYSTEM_EXCEPTION)
        else:
            describe = 'Approve status not in (0,1,2,3)'
            return interface_response(MESSAGE_CODE, '', '', describe, DATA_EXCEPTION)

    @request_valid
    @ladonize(int, int, str, int, str, str, str, rtype=str)
    def approve(self, code, approve_status, remark, source, device_token, language, token):
        """
        请假审批
        @param code:            对象ID
        @param approve_status:  审批状态（2:通过/3:拒绝）
        @param source:          数据来源(1: IOS， 2：Android)
        @param device_token:    消息推送Token
        @param language:
        @param token:
        @rtype:
            请求成功
                {"code":1,"error":"","describe":"","message":"","data":{"message":"弹窗信息"}}
            请求失败
                {"code":-10001,"error":"","describe":"","message":"弹窗信息","data":""}
        """
        from mysite.att.models.model_empspecday import EmpSpecDay
        from mysite.att import constant
        from mysite.att.att_utils import approve_flow, save_history
        if code:
            if approve_status not in (constant.AUDIT_SUCCESS, constant.REFUSE):
                describe = 'param approve_status out of range'
                return interface_response(MESSAGE_CODE, '', '', describe, DATA_EXCEPTION)
            approver = online_employee()
            objs = EmpSpecDay.objects.filter(id=code)
            if objs:
                try:
                    obj = objs[0]
                    applier = obj.emp
                    level = obj.approve_level
                    obj.audit_reason = u'{0}'.format(remark.decode('utf-8'))
                    obj.audit_user_id = approver.pk
                    approver_name = approver.EName or approver.PIN
                    obj, approve_level = approve_flow(constant.CATEGORY_LEAVE, obj, applier, applier.PIN, '', approver_name, approve_status)
                    obj.save()
                    approver = approver.PIN
                    save_history(constant.CATEGORY_LEAVE, obj.pk, level, approve_status, approver, approver_name, remark)
                    data = {
                        'message': u'{0}'.format(_(u'OK'))
                    }
                    return interface_response(SUCCESS_CODE, json.dumps(data), '', 'successful')
                except Exception, e:
                    print u'{0}'.format(e)
                    return interface_response(MESSAGE_CODE, '', '', e, SYSTEM_EXCEPTION)
            else:
                describe = 'Object Not Found'
                return interface_response(MESSAGE_CODE, '', '', describe, DATA_EXCEPTION)
        else:
            describe = _(u'Object Not Found')
            return interface_response(MESSAGE_CODE, '', '', describe, DATA_EXCEPTION)

    @request_valid
    @ladonize(int, int, str, str, str, rtype=str)
    def revoke(self, code, source, device_token, language, token):
        """
        审批撤销
        @param code:            对象ID
        @param source:          数据来源(1: IOS， 2：Android)
        @param device_token:    消息推送Token
        @param language:
        @param token:
        @rtype:
        """
        from mysite.att.models.model_empspecday import EmpSpecDay
        from mysite.att import constant
        from mysite.att.att_utils import approve_flow, save_history
        if code:
            approver = online_employee()
            objs = EmpSpecDay.objects.filter(id=code)
            if objs:
                try:
                    obj = objs[0]
                    applier = obj.emp
                    if obj.audit_status not in (constant.AUDIT_SUCCESS, ):
                        describe = _(u'Not allowed')
                        return interface_response(MESSAGE_CODE, '', '', describe, describe)
                    obj.audit_status = constant.CANCEL_AUDIT_SUCCESS
                    obj.audit_user_id = applier.pk
                    obj.audit_reason = ''
                    super(EmpSpecDay, obj).save()
                    approve_level = obj.approve_level + 1
                    approver_name = approver.EName or approver.PIN
                    approver = approver.PIN
                    obj, approve_level = approve_flow(constant.CATEGORY_LEAVE, obj, applier, applier.PIN, '', approver, constant.CANCEL_AUDIT_SUCCESS)
                    obj.save()
                    save_history(constant.CATEGORY_LEAVE, obj.pk, approve_level, constant.CANCEL_AUDIT_SUCCESS, approver, approver_name, '')
                    data = {
                        'message': u'{0}'.format(_(u'OK'))
                    }
                    return interface_response(SUCCESS_CODE, json.dumps(data), '', 'successful')
                except Exception, e:
                    import traceback
                    traceback.print_exc()
                    return interface_response(MESSAGE_CODE, '', '', e, SYSTEM_EXCEPTION)
            else:
                describe = 'Object Not Found'
                return interface_response(MESSAGE_CODE, '', '', describe, DATA_EXCEPTION)
        else:
            return interface_response(MESSAGE_CODE, '', '', 'Object Not Found', DATA_EXCEPTION)